/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.compat;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lukebemish.defaultresources.api.ResourceProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.ultrusmods.missingwilds.Constants;
import me.ultrusmods.missingwilds.MissingWildsForge;
import me.ultrusmods.missingwilds.data.LogData;
import me.ultrusmods.missingwilds.data.ModCompat;
import me.ultrusmods.missingwilds.platform.Services;
import me.ultrusmods.missingwilds.register.MissingWildsBlocks;
import me.ultrusmods.missingwilds.register.MissingWildsItems;
import me.ultrusmods.missingwilds.register.RegistryObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;

public class ForgeModCompatHandler {
    public static HashMap<String, ModCompat> modCompats = new HashMap();
    private static final Gson GSON = new Gson();
    private final List<LogData> logList = new ArrayList<LogData>();
    private static final HashMap<String, RegistryObject<Item>> itemMap = new HashMap();
    private static final HashMap<String, RegistryObject<Block>> blockMap = new HashMap();

    public static void checkModCompat() {
        ForgeModCompatHandler.loadModCompat();
    }

    public static void loadModCompat() {
        ResourceProvider.forceInitialization();
        Collection resourceLocations = ResourceProvider.instance().getResources("missingwilds", "compat", predicate -> true);
        for (ResourceLocation resource : resourceLocations) {
            try {
                Stream resourceStream = ResourceProvider.instance().getResourceStreams("missingwilds", resource);
                try {
                    Optional optional = resourceStream.findFirst();
                    if (!optional.isPresent() || !resource.m_135815_().endsWith(".json")) continue;
                    InputStream stream = (InputStream)optional.get();
                    JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                    ModCompat modCompat = (ModCompat)ModCompat.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)Constants.LOG).error(arg_0));
                    if (!Services.PLATFORM.isModLoaded(modCompat.modid())) continue;
                    modCompats.put(modCompat.modid(), modCompat);
                }
                finally {
                    if (resourceStream == null) continue;
                    resourceStream.close();
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load mod compat file {} with error {}", (Object)resource, (Object)e.getMessage());
            }
        }
    }

    public static void registerModCompatBlocks() {
        modCompats.values().forEach(modCompat -> modCompat.logs().forEach(logEither -> {
            LogData logData = logEither.left().isPresent() ? ForgeModCompatHandler.getSimpleLogName((String)logEither.left().get(), modCompat.modid()) : (LogData)logEither.right().get();
            ForgeModCompatHandler.addLogBlock(logData, modCompat.modid());
        }));
    }

    public static void registerModCompatItems() {
        modCompats.values().forEach(modCompat -> modCompat.logs().forEach(logEither -> {
            LogData logData = logEither.left().isPresent() ? ForgeModCompatHandler.getSimpleLogName((String)logEither.left().get(), modCompat.modid()) : (LogData)logEither.right().get();
            ForgeModCompatHandler.addLogItem(logData, modCompat.modid());
        }));
    }

    public static void addLogItem(LogData logData, String modid) {
        RegistryObject<Item> item = MissingWildsItems.register(modid + "_" + logData.name(), ForgeModCompatHandler.getLogsBlocks().get(logData.blockId()));
        ForgeModCompatHandler.addItem(item, logData.blockId());
    }

    public static void addLogBlock(LogData logData, String modid) {
        RegistryObject<Block> block = MissingWildsBlocks.registerFallenLog(modid + "_" + logData.name());
        ForgeModCompatHandler.addBlock(block, logData.blockId());
        MissingWildsForge.COMPAT_LOGS.add(block);
    }

    public List<LogData> getLogList() {
        return this.logList;
    }

    public static LogData getSimpleLogName(String logName, String modId) {
        return new LogData("fallen_" + logName, modId + ":" + logName, modId + ":block/" + logName, modId + ":block/stripped_" + logName);
    }

    public static HashMap<String, RegistryObject<Block>> getLogsBlocks() {
        return blockMap;
    }

    public static HashMap<String, RegistryObject<Item>> getLogItems() {
        return itemMap;
    }

    public static void addBlock(RegistryObject<Block> block, String blockId) {
        blockMap.put(blockId, block);
    }

    public static void addItem(RegistryObject<Item> item, String itemId) {
        itemMap.put(itemId, item);
    }
}

